-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p1 = Citadels.GetPlayer(1)
    self.p0 = Citadels.GetPlayer(0)
    self.limit = {}    
    
    if not self.loaded then
      self.active = true
      self.attacksCounter = 0
      self.difCoef = Citadels.GetPlayer(0):GetDifficultyCoef()
      SetAi(self)
    end
    
    SetLimits(self)
    
    if not self.loaded then
      self.timer = self.limit[0] -- setup for first attack  
    end
    
    self.waveMeadow:LinkToTarget("attMeadow")
    self.waveValley:LinkToTarget("attValley")
    self.waveLake:LinkToTarget("attLake")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
		
		--if self.timer <= 60 then
		if self.timer <= 0 then
      self.attacksCounter = self.attacksCounter + 1
      SendAttack(self)
      self.p0:ShowInfo("ttincoming")
    end    
  end
end

function SendAttack(self)
  if self.attacksCounter == 1 then
    self.timer = self.limit[1]
		self.waveMeadow:TriggerAllTargets()
  elseif self.attacksCounter == 2 then
    self.timer = self.limit[2]
    self.waveValley:TriggerAllTargets()
  elseif self.attacksCounter == 3 then
    self.waveLake:TriggerAllTargets()
  else
		return
	end
	self.active = false
end

function SetAi(self)
  self.p1:AISetAutoMode(true)
  self.p1:AISetEverythingVisible(true)
end

function SetLimits(self)
  self.limit[0] = 180 / self.difCoef 
  self.limit[1] = 200 / self.difCoef 
  self.limit[2] = 200 / self.difCoef 
end

function OnTrigger(self, source, target)
	if target == "activateAttHandler" then
		self.active = true
	end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
    self.attacksCounter = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
    ar:Write(self.attacksCounter)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("activateAttHandler")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("waveMeadow")
  self:AddTriggerSource("waveValley")
  self:AddTriggerSource("waveLake")
end
